<?php
require_once("fpdf/fpdf.php");

//creamos una clase para ocupar el encabezado y pie de pagina en el PDF
class PDF_Code128 extends FPDF {

protected $T128;                                         // Tableau des codes 128
protected $ABCset = "";                                  // jeu des caractères éligibles au C128
protected $Aset = "";                                    // Set A du jeu des caractères éligibles
protected $Bset = "";                                    // Set B du jeu des caractères éligibles
protected $Cset = "";                                    // Set C du jeu des caractères éligibles
protected $SetFrom;                                      // Convertisseur source des jeux vers le tableau
protected $SetTo;                                        // Convertisseur destination des jeux vers le tableau
protected $JStart = array("A"=>103, "B"=>104, "C"=>105); // Caractères de sélection de jeu au début du C128
protected $JSwap = array("A"=>101, "B"=>100, "C"=>99);   // Caractères de changement de jeu

//____________________________ Extension du constructeur _______________________
function __construct($orientation='P', $unit='mm', $format='A4') {

    parent::__construct($orientation,$unit,$format);

    $this->T128[] = array(2, 1, 2, 2, 2, 2);           //0 : [ ]               // composition des caractères
    $this->T128[] = array(2, 2, 2, 1, 2, 2);           //1 : [!]
    $this->T128[] = array(2, 2, 2, 2, 2, 1);           //2 : ["]
    $this->T128[] = array(1, 2, 1, 2, 2, 3);           //3 : [#]
    $this->T128[] = array(1, 2, 1, 3, 2, 2);           //4 : [$]
    $this->T128[] = array(1, 3, 1, 2, 2, 2);           //5 : [%]
    $this->T128[] = array(1, 2, 2, 2, 1, 3);           //6 : [&]
    $this->T128[] = array(1, 2, 2, 3, 1, 2);           //7 : [']
    $this->T128[] = array(1, 3, 2, 2, 1, 2);           //8 : [(]
    $this->T128[] = array(2, 2, 1, 2, 1, 3);           //9 : [)]
    $this->T128[] = array(2, 2, 1, 3, 1, 2);           //10 : [*]
    $this->T128[] = array(2, 3, 1, 2, 1, 2);           //11 : [+]
    $this->T128[] = array(1, 1, 2, 2, 3, 2);           //12 : [,]
    $this->T128[] = array(1, 2, 2, 1, 3, 2);           //13 : [-]
    $this->T128[] = array(1, 2, 2, 2, 3, 1);           //14 : [.]
    $this->T128[] = array(1, 1, 3, 2, 2, 2);           //15 : [/]
    $this->T128[] = array(1, 2, 3, 1, 2, 2);           //16 : [0]
    $this->T128[] = array(1, 2, 3, 2, 2, 1);           //17 : [1]
    $this->T128[] = array(2, 2, 3, 2, 1, 1);           //18 : [2]
    $this->T128[] = array(2, 2, 1, 1, 3, 2);           //19 : [3]
    $this->T128[] = array(2, 2, 1, 2, 3, 1);           //20 : [4]
    $this->T128[] = array(2, 1, 3, 2, 1, 2);           //21 : [5]
    $this->T128[] = array(2, 2, 3, 1, 1, 2);           //22 : [6]
    $this->T128[] = array(3, 1, 2, 1, 3, 1);           //23 : [7]
    $this->T128[] = array(3, 1, 1, 2, 2, 2);           //24 : [8]
    $this->T128[] = array(3, 2, 1, 1, 2, 2);           //25 : [9]
    $this->T128[] = array(3, 2, 1, 2, 2, 1);           //26 : [:]
    $this->T128[] = array(3, 1, 2, 2, 1, 2);           //27 : [;]
    $this->T128[] = array(3, 2, 2, 1, 1, 2);           //28 : [<]
    $this->T128[] = array(3, 2, 2, 2, 1, 1);           //29 : [=]
    $this->T128[] = array(2, 1, 2, 1, 2, 3);           //30 : [>]
    $this->T128[] = array(2, 1, 2, 3, 2, 1);           //31 : [?]
    $this->T128[] = array(2, 3, 2, 1, 2, 1);           //32 : [@]
    $this->T128[] = array(1, 1, 1, 3, 2, 3);           //33 : [A]
    $this->T128[] = array(1, 3, 1, 1, 2, 3);           //34 : [B]
    $this->T128[] = array(1, 3, 1, 3, 2, 1);           //35 : [C]
    $this->T128[] = array(1, 1, 2, 3, 1, 3);           //36 : [D]
    $this->T128[] = array(1, 3, 2, 1, 1, 3);           //37 : [E]
    $this->T128[] = array(1, 3, 2, 3, 1, 1);           //38 : [F]
    $this->T128[] = array(2, 1, 1, 3, 1, 3);           //39 : [G]
    $this->T128[] = array(2, 3, 1, 1, 1, 3);           //40 : [H]
    $this->T128[] = array(2, 3, 1, 3, 1, 1);           //41 : [I]
    $this->T128[] = array(1, 1, 2, 1, 3, 3);           //42 : [J]
    $this->T128[] = array(1, 1, 2, 3, 3, 1);           //43 : [K]
    $this->T128[] = array(1, 3, 2, 1, 3, 1);           //44 : [L]
    $this->T128[] = array(1, 1, 3, 1, 2, 3);           //45 : [M]
    $this->T128[] = array(1, 1, 3, 3, 2, 1);           //46 : [N]
    $this->T128[] = array(1, 3, 3, 1, 2, 1);           //47 : [O]
    $this->T128[] = array(3, 1, 3, 1, 2, 1);           //48 : [P]
    $this->T128[] = array(2, 1, 1, 3, 3, 1);           //49 : [Q]
    $this->T128[] = array(2, 3, 1, 1, 3, 1);           //50 : [R]
    $this->T128[] = array(2, 1, 3, 1, 1, 3);           //51 : [S]
    $this->T128[] = array(2, 1, 3, 3, 1, 1);           //52 : [T]
    $this->T128[] = array(2, 1, 3, 1, 3, 1);           //53 : [U]
    $this->T128[] = array(3, 1, 1, 1, 2, 3);           //54 : [V]
    $this->T128[] = array(3, 1, 1, 3, 2, 1);           //55 : [W]
    $this->T128[] = array(3, 3, 1, 1, 2, 1);           //56 : [X]
    $this->T128[] = array(3, 1, 2, 1, 1, 3);           //57 : [Y]
    $this->T128[] = array(3, 1, 2, 3, 1, 1);           //58 : [Z]
    $this->T128[] = array(3, 3, 2, 1, 1, 1);           //59 : [[]
    $this->T128[] = array(3, 1, 4, 1, 1, 1);           //60 : [\]
    $this->T128[] = array(2, 2, 1, 4, 1, 1);           //61 : []]
    $this->T128[] = array(4, 3, 1, 1, 1, 1);           //62 : [^]
    $this->T128[] = array(1, 1, 1, 2, 2, 4);           //63 : [_]
    $this->T128[] = array(1, 1, 1, 4, 2, 2);           //64 : [`]
    $this->T128[] = array(1, 2, 1, 1, 2, 4);           //65 : [a]
    $this->T128[] = array(1, 2, 1, 4, 2, 1);           //66 : [b]
    $this->T128[] = array(1, 4, 1, 1, 2, 2);           //67 : [c]
    $this->T128[] = array(1, 4, 1, 2, 2, 1);           //68 : [d]
    $this->T128[] = array(1, 1, 2, 2, 1, 4);           //69 : [e]
    $this->T128[] = array(1, 1, 2, 4, 1, 2);           //70 : [f]
    $this->T128[] = array(1, 2, 2, 1, 1, 4);           //71 : [g]
    $this->T128[] = array(1, 2, 2, 4, 1, 1);           //72 : [h]
    $this->T128[] = array(1, 4, 2, 1, 1, 2);           //73 : [i]
    $this->T128[] = array(1, 4, 2, 2, 1, 1);           //74 : [j]
    $this->T128[] = array(2, 4, 1, 2, 1, 1);           //75 : [k]
    $this->T128[] = array(2, 2, 1, 1, 1, 4);           //76 : [l]
    $this->T128[] = array(4, 1, 3, 1, 1, 1);           //77 : [m]
    $this->T128[] = array(2, 4, 1, 1, 1, 2);           //78 : [n]
    $this->T128[] = array(1, 3, 4, 1, 1, 1);           //79 : [o]
    $this->T128[] = array(1, 1, 1, 2, 4, 2);           //80 : [p]
    $this->T128[] = array(1, 2, 1, 1, 4, 2);           //81 : [q]
    $this->T128[] = array(1, 2, 1, 2, 4, 1);           //82 : [r]
    $this->T128[] = array(1, 1, 4, 2, 1, 2);           //83 : [s]
    $this->T128[] = array(1, 2, 4, 1, 1, 2);           //84 : [t]
    $this->T128[] = array(1, 2, 4, 2, 1, 1);           //85 : [u]
    $this->T128[] = array(4, 1, 1, 2, 1, 2);           //86 : [v]
    $this->T128[] = array(4, 2, 1, 1, 1, 2);           //87 : [w]
    $this->T128[] = array(4, 2, 1, 2, 1, 1);           //88 : [x]
    $this->T128[] = array(2, 1, 2, 1, 4, 1);           //89 : [y]
    $this->T128[] = array(2, 1, 4, 1, 2, 1);           //90 : [z]
    $this->T128[] = array(4, 1, 2, 1, 2, 1);           //91 : [{]
    $this->T128[] = array(1, 1, 1, 1, 4, 3);           //92 : [|]
    $this->T128[] = array(1, 1, 1, 3, 4, 1);           //93 : [}]
    $this->T128[] = array(1, 3, 1, 1, 4, 1);           //94 : [~]
    $this->T128[] = array(1, 1, 4, 1, 1, 3);           //95 : [DEL]
    $this->T128[] = array(1, 1, 4, 3, 1, 1);           //96 : [FNC3]
    $this->T128[] = array(4, 1, 1, 1, 1, 3);           //97 : [FNC2]
    $this->T128[] = array(4, 1, 1, 3, 1, 1);           //98 : [SHIFT]
    $this->T128[] = array(1, 1, 3, 1, 4, 1);           //99 : [Cswap]
    $this->T128[] = array(1, 1, 4, 1, 3, 1);           //100 : [Bswap]                
    $this->T128[] = array(3, 1, 1, 1, 4, 1);           //101 : [Aswap]
    $this->T128[] = array(4, 1, 1, 1, 3, 1);           //102 : [FNC1]
    $this->T128[] = array(2, 1, 1, 4, 1, 2);           //103 : [Astart]
    $this->T128[] = array(2, 1, 1, 2, 1, 4);           //104 : [Bstart]
    $this->T128[] = array(2, 1, 1, 2, 3, 2);           //105 : [Cstart]
    $this->T128[] = array(2, 3, 3, 1, 1, 1);           //106 : [STOP]
    $this->T128[] = array(2, 1);                       //107 : [END BAR]

    for ($i = 32; $i <= 95; $i++) {                                            // jeux de caractères
        $this->ABCset .= chr($i);
    }
    $this->Aset = $this->ABCset;
    $this->Bset = $this->ABCset;
    
    for ($i = 0; $i <= 31; $i++) {
        $this->ABCset .= chr($i);
        $this->Aset .= chr($i);
    }
    for ($i = 96; $i <= 127; $i++) {
        $this->ABCset .= chr($i);
        $this->Bset .= chr($i);
    }
    for ($i = 200; $i <= 210; $i++) {                                           // controle 128
        $this->ABCset .= chr($i);
        $this->Aset .= chr($i);
        $this->Bset .= chr($i);
    }
    $this->Cset="0123456789".chr(206);

    for ($i=0; $i<96; $i++) {                                                   // convertisseurs des jeux A & B
        @$this->SetFrom["A"] .= chr($i);
        @$this->SetFrom["B"] .= chr($i + 32);
        @$this->SetTo["A"] .= chr(($i < 32) ? $i+64 : $i-32);
        @$this->SetTo["B"] .= chr($i);
    }
    for ($i=96; $i<107; $i++) {                                                 // contrôle des jeux A & B
        @$this->SetFrom["A"] .= chr($i + 104);
        @$this->SetFrom["B"] .= chr($i + 104);
        @$this->SetTo["A"] .= chr($i);
        @$this->SetTo["B"] .= chr($i);
    }
}

//________________ Fonction encodage et dessin du code 128 _____________________
function Code128($x, $y, $code, $w, $h) {
    $Aguid = "";                                                                      // Création des guides de choix ABC
    $Bguid = "";
    $Cguid = "";
    for ($i=0; $i < strlen($code); $i++) {
        $needle = substr($code,$i,1);
        $Aguid .= ((strpos($this->Aset,$needle)===false) ? "N" : "O"); 
        $Bguid .= ((strpos($this->Bset,$needle)===false) ? "N" : "O"); 
        $Cguid .= ((strpos($this->Cset,$needle)===false) ? "N" : "O");
    }

    $SminiC = "OOOO";
    $IminiC = 4;

    $crypt = "";
    while ($code > "") {
                                                                                    // BOUCLE PRINCIPALE DE CODAGE
        $i = strpos($Cguid,$SminiC);                                                // forçage du jeu C, si possible
        if ($i!==false) {
            $Aguid [$i] = "N";
            $Bguid [$i] = "N";
        }

        if (substr($Cguid,0,$IminiC) == $SminiC) {                                  // jeu C
            $crypt .= chr(($crypt > "") ? $this->JSwap["C"] : $this->JStart["C"]);  // début Cstart, sinon Cswap
            $made = strpos($Cguid,"N");                                             // étendu du set C
            if ($made === false) {
                $made = strlen($Cguid);
            }
            if (fmod($made,2)==1) {
                $made--;                                                            // seulement un nombre pair
            }
            for ($i=0; $i < $made; $i += 2) {
                $crypt .= chr(strval(substr($code,$i,2)));                          // conversion 2 par 2
            }
            $jeu = "C";
        } else {
            $madeA = strpos($Aguid,"N");                                            // étendu du set A
            if ($madeA === false) {
                $madeA = strlen($Aguid);
            }
            $madeB = strpos($Bguid,"N");                                            // étendu du set B
            if ($madeB === false) {
                $madeB = strlen($Bguid);
            }
            $made = (($madeA < $madeB) ? $madeB : $madeA );                         // étendu traitée
            $jeu = (($madeA < $madeB) ? "B" : "A" );                                // Jeu en cours

            $crypt .= chr(($crypt > "") ? $this->JSwap[$jeu] : $this->JStart[$jeu]); // début start, sinon swap

            $crypt .= strtr(substr($code, 0,$made), $this->SetFrom[$jeu], $this->SetTo[$jeu]); // conversion selon jeu

        }
        $code = substr($code,$made);                                           // raccourcir légende et guides de la zone traitée
        $Aguid = substr($Aguid,$made);
        $Bguid = substr($Bguid,$made);
        $Cguid = substr($Cguid,$made);
    }                                                                          // FIN BOUCLE PRINCIPALE

    $check = ord($crypt[0]);                                                   // calcul de la somme de contrôle
    for ($i=0; $i<strlen($crypt); $i++) {
        $check += (ord($crypt[$i]) * $i);
    }
    $check %= 103;

    $crypt .= chr($check) . chr(106) . chr(107);                               // Chaine cryptée complète

    $i = (strlen($crypt) * 11) - 8;                                            // calcul de la largeur du module
    $modul = $w/$i;

    for ($i=0; $i<strlen($crypt); $i++) {                                      // BOUCLE D'IMPRESSION
        $c = $this->T128[ord($crypt[$i])];
        for ($j=0; $j<count($c); $j++) {
            $this->Rect($x,$y,$c[$j]*$modul,$h,"F");
            $x += ($c[$j++]+$c[$j])*$modul;
        }
    }
}
	protected $B = 0;
	protected $I = 0;
	protected $U = 0;
	protected $HREF = '';
	
	function inicio($rsocial,$ncomercial,$ruc,$titulo){
		//substr($nprove1,80)
	$this->Ln();
	$this->Ln();
	$this->Ln();
	$this->Ln();
	$this->Ln();
	$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,'','TLR',1,'L');
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',12);
	$this->Cell(90,5,utf8_decode($rsocial),'LR',1,'L');
    //Titulo del reporte	
	$this->SetFont('Arial','',10);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,5,'RUC: ','L',0,'L');
	$this->Cell(80,5,$ruc,'R',1,'L'); 
	$this->Cell(101,30,' ',0,0,'C');
	$this->Cell(90,5,$titulo,'LRB',0,'L');
	 //Titulo del reporte
	
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');	
	$this->SetFont('Arial','B',11);
	
	$this->Cell(90,2,'',0,1,'L');
	}
	
	
	function iniciocc($rsocial,$ncomercial,$ruc,$titulo,$fdesde,$fhasta){
		//substr($nprove1,80)
	$this->Ln();
	$this->Ln();
	$this->Ln();

	$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,utf8_decode(substr($rsocial,0,38)),'TLR',1,'J');
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,utf8_decode(substr($rsocial,38,20)),'LR',1,'J');
    //Titulo del reporte	
	$this->SetFont('Arial','',10);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,5,'RUC: ','L',0,'L');
	$this->Cell(80,5,$ruc,'R',1,'L'); 
	$this->Cell(101,30,' ',0,0,'C');
	$this->Cell(90,5,$titulo,'LRB',0,'L');
	 //Titulo del reporte
	
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');	
	$this->SetFont('Arial','B',11);
	
	$this->Cell(90,2,'',0,1,'L');
	$this->Ln();
	$this->Ln();
	
	}
	
	function inicioccf($rsocial,$ncomercial,$ruc,$titulo,$fdesde,$fhasta){
		//substr($nprove1,80)
	$this->Ln();
	$this->Ln();
	$this->Ln();

	$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,utf8_decode(substr($rsocial,0,38)),'TLR',1,'J');
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,utf8_decode(substr($rsocial,38,20)),'LR',1,'J');
    //Titulo del reporte	
	$this->SetFont('Arial','',10);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,5,'RUC: ','L',0,'L');
	$this->Cell(80,5,$ruc,'R',1,'L'); 
	$this->Cell(101,30,' ',0,0,'C');
	$this->Cell(90,5,$titulo,'LRB',0,'L');
	 //Titulo del reporte
	
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');	
	$this->SetFont('Arial','B',11);
	
	$this->Cell(90,2,'',0,1,'L');
	$this->Ln();
	$this->Ln();
	$ubicaf = 40;
	$this->SetXY(90,$ubicaf);
	$this->Cell(25,6,'Fecha Desde: ',0,0,'R');
	$this->Cell(30,6,substr($fdesde,0,4).'/'.substr($fdesde,4,2).'/'.substr($fdesde,6,2),0,0,'R');
	$this->Cell(30,6,' Fecha Hasta: ',0,0,'R');
	$this->Cell(30,6,substr($fhasta,0,4).'/'.substr($fhasta,4,2).'/'.substr($fhasta,6,2),0,0,'R');
	$this->Ln();
	$this->Ln();
	}
	
	function datoslote($lote,$nombres,$direccion){
		//substr($nprove1,80)
	
	$this->Ln();
	//$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,'','TLR',1,'L');
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',12);
	$this->Cell(90,5,$lote,'LR',1,'L');
    //Titulo del reporte	
	$this->SetFont('Arial','',10);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,5,'','L',0,'L');
	$this->Cell(80,5,$nombres,'R',1,'L'); 
	$this->Cell(101,30,' ',0,0,'C');
	$this->Cell(90,5,$direccion,'LRB',0,'L');
	 //Titulo del reporte
	
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');	
	$this->SetFont('Arial','B',11);
	
	$this->Cell(90,2,'',0,1,'L');
	}
	
	function detalle($cn){
		$sqlord = "SELECT 
					CuentaContableId,
					EmpresaId,
					tiposId,
					tiposmovimientosId,
					CuentaContableNombre,
					CuentaContableDescripcion,
					estado,
					fecharegistro,
					usuario,
					CuentaContablePadreId,
					cuentacodigo,
					valores,
					ultimonivel
				FROM 
					cuentacontable
				WHERE
					tiposid in (1,2,3)	
				order by tiposid, cuentacontableid asc";
		
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de factura Pdf detalle reportes contables";
				//exit;

		} else {
			
				$ubicaf = 50;
				

			while($fila = $resulm->fetch_assoc()){ 
				$valores = $fila['valores'];
				$tipos = $fila['tiposId'];
				$padreid = $fila['CuentaContablePadreId'];
				$ultimonivel = $fila['ultimonivel'];
				$cuentaid = $fila['CuentaContableId'];
				
				$saldo = calculasaldob($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores);
				$this->SetFont('Arial','',8);
				 $this->SetXY(60,$ubicaf);
				 $y1 = $this->GetY();
				 $x1 = $this->GetX();			 
				 $this->Cell(100,4,$fila['CuentaContableNombre'],0,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
				 $y2 = $this->GetY();
				 $alto = $y2 - $y1 ;
				 $alto = 5;
				 $this->SetXY(10,$ubicaf);
				 $this->Cell(60,$alto,$fila['cuentacodigo'],0,0); //id  
				 $this->SetXY(180,$ubicaf);
				 $this->Cell(15,$alto,$saldo,0,1,'C');
				 $ubicaf = $ubicaf + 5;
				 
			}
		}

	}
	
	
	function detallebc($cn){
		$sqlord = "SELECT 
					CuentaContableId,
					EmpresaId,
					tiposId,
					tiposmovimientosId,
					CuentaContableNombre,
					CuentaContableDescripcion,
					estado,
					fecharegistro,
					usuario,
					CuentaContablePadreId,
					cuentacodigo,
					valores,
					ultimonivel,
					saldoanterior
				FROM 
					cuentacontable
				WHERE
					tiposid in (1,2,3,4,6)	
				order by tiposid, cuentacontableid asc";
		
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de balance comprobacion Pdf detalle reportes contables";
				//exit;

		} else {
			
				$ubicaf = 50;
				

			while($fila = $resulm->fetch_assoc()){ 
				$valores = $fila['valores'];
				$tipos = $fila['tiposId'];
				$padreid = $fila['CuentaContablePadreId'];
				$ultimonivel = $fila['ultimonivel'];
				$cuentaid = $fila['CuentaContableId'];
				$saldoant = $fila['saldoanterior'];
				
				$tipoc = 'D';
				$debe = traedebehaber($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores,$tipoc);
				$tipoc = 'C';
				$haber = traedebehaber($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores,$tipoc);
				$saldo = calculasaldob($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores);
				$this->SetFont('Arial','',8);
				 $this->SetXY(40,$ubicaf);
				 $y1 = $this->GetY();
				 $x1 = $this->GetX();			 
				 $this->Cell(60,5,$fila['CuentaContableNombre'],0,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
				 $y2 = $this->GetY();
				 $alto = $y2 - $y1 ;
				 $alto = 5;
				 $this->SetXY(10,$ubicaf);
				 $this->Cell(40,$alto,$fila['cuentacodigo'],0,0); //id 
				 $this->SetXY(120,$ubicaf);
				 $this->Cell(15,$alto,$saldoant,0,0,'R');
				$this->SetXY(140,$ubicaf);
				 $this->Cell(15,$alto,$debe,0,0,'R');
				$this->SetXY(160,$ubicaf);
				 $this->Cell(15,$alto,$haber,0,0,'R');				 
				 $this->SetXY(180,$ubicaf);
				 $this->Cell(15,$alto,$saldo,0,1,'R');
				 $ubicaf = $ubicaf + 5;
				 
			}
		}

	}
	
	function totalesbal($cn){
		
		$tipos = 1;
		$saldoact = calculasaldotipos($cn,$tipos);
		$tipos = 2;
		$saldopas = calculasaldotipos($cn,$tipos);
		$tipos = 3;
		$saldocap = calculasaldotipos($cn,$tipos);
		
		$this->ln();
		$this->Cell(40,5,'',0,0,'L');
		$this->Cell(40,5,'ACTIVO',1,0,'l'); //Titulo del reporte
		$fbaseimp = $english_format_number = number_format($saldoact, 2, '.', '');
		$this->Cell(21,5,$saldoact,1,1,'R');
		
		$this->Cell(40,5,'',0,0,'L');
		$this->Cell(40,5,'PASIVO',1,0,'l'); //Titulo del reporte
		$fbaseimp = $english_format_number = number_format($saldopas, 2, '.', '');
		$this->Cell(21,5,$saldopas,1,1,'R');
		
		$this->Cell(40,5,'',0,0,'L');
		$this->Cell(40,5,'CAPITAL',1,0,'l'); //Titulo del reporte
		$fbaseimp = $english_format_number = number_format($saldocap, 2, '.', '');
		$this->Cell(21,5,$saldocap,1,1,'R');
	}
	
	
	function totalesbalcomp($cn){
		
		$tipoc ='D';
		$debet =  calculadebhabtotal($cn,$tipoc);
		$tipoc ='C';
		$habert =  calculadebhabtotal($cn,$tipoc);
		$saldoact = calculasaldototal($cn);
		
		
		$this->ln();
		$this->Cell(130,5,'TOTALES: ',0,0,'R');
		//$this->Cell(40,5,'DEBE',1,0,'l'); //Titulo del reporte
		$debet1 = $english_format_number = number_format($debet, 2, '.', '');
		$this->Cell(20,5,$debet1,1,0,'R');
		
		//$this->Cell(40,5,'',0,0,'L');
		//$this->Cell(40,5,'HABER',1,0,'l'); //Titulo del reporte
		$habert1 = $english_format_number = number_format($habert, 2, '.', '');
		$this->Cell(20,5,$habert1,1,0,'R');
		
		//$this->Cell(40,5,'',0,0,'L');
		//$this->Cell(40,5,'SALDO',1,0,'l'); //Titulo del reporte
		$saldoact1 = $english_format_number = number_format($saldoact, 2, '.', '');
		$this->Cell(20,5,$saldoact1,1,1,'R');
	}
	
		function detallean($cn){
		$sqlord = "SELECT 
					CuentaContableId,
					EmpresaId,
					tiposId,
					tiposmovimientosId,
					CuentaContableNombre,
					CuentaContableDescripcion,
					estado,
					fecharegistro,
					usuario,
					CuentaContablePadreId,
					cuentacodigo,
					valores,
					ultimonivel
				FROM 
					cuentacontable
				WHERE
					tiposid in (4,6)	
				order by tiposid, cuentacontableid asc";
		
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de factura Pdf detalle reportes contables";
				//exit;

		} else {
			
				$ubicaf = 50;
				

			while($fila = $resulm->fetch_assoc()){ 
				$valores = $fila['valores'];
				$tipos = $fila['tiposId'];
				$padreid = $fila['CuentaContablePadreId'];
				$ultimonivel = $fila['ultimonivel'];
				$cuentaid = $fila['CuentaContableId'];
				
				
				$saldo = calculasaldob($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores);
				$this->SetFont('Arial','',8);
				 $this->SetXY(60,$ubicaf);
				 $y1 = $this->GetY();
				 $x1 = $this->GetX();			 
				 $this->Cell(100,4,$fila['CuentaContableNombre'],0,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
				 $y2 = $this->GetY();
				 $alto = $y2 - $y1 ;
				 $alto = 5;
				 $this->SetXY(10,$ubicaf);
				 $this->Cell(60,$alto,$fila['cuentacodigo'],0,0); //id  
				 $this->SetXY(180,$ubicaf);
				 $this->Cell(15,$alto,$saldo,0,1,'C');
				 $ubicaf = $ubicaf + 5;
				 
			}
		}

	}
	
	
	function totalesan($cn){
		
		$tipos = 4;
		$saldoact = calculasaldotipos($cn,$tipos);
		$tipos = 6;
		$saldopas = calculasaldotipos($cn,$tipos);
		
		
		$this->ln();
		$this->Cell(40,5,'',0,0,'L');
		$this->Cell(40,5,'INGRESOS',1,0,'l'); //Titulo del reporte
		$saldoact2 = $english_format_number = number_format($saldoact, 2, '.', '');
		$this->Cell(21,5,$saldoact2,1,1,'R');
		
		$this->Cell(40,5,'',0,0,'L');
		$this->Cell(40,5,'GASTOS',1,0,'l'); //Titulo del reporte
		$saldopas2 = $english_format_number = number_format($saldopas, 2, '.', '');
		$this->Cell(21,5,$saldopas2,1,1,'R');
		
	}
	
	
	function totales($fbaseimp,$fdescuento,$fiva,$ftotalimp,$dircliente,$corcliente,$telcliente,$txnid,$serie,$fbaseimp0,$utiempo,$dplazo,$descsri,$ftotalimp){
		//$this->Cell(15,7,'',0,0,'L'); 
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL 12%',1,0,'l'); //Titulo del reporte
		$fbaseimp = $english_format_number = number_format($fbaseimp, 2, '.', '');
		$this->Cell(21,5,$fbaseimp,1,1,'R'); //Titulo del reporte
		
		
		
		$this->Cell(130,5,'INFORMACION ADICIONAL',0,0,'C');
		$this->Cell(40,5,'SUBTOTAL 0%',1,0,'l'); //Titulo del reporte
		$fbaseimp0 = $english_format_number = number_format($fbaseimp0, 2, '.', '');
		$this->Cell(21,5,$fbaseimp0,1,1,'R'); //Titulo del reporte
		
		$this->Cell(28,5,'CORREO: ','TL',0,'L');
		$this->Cell(100,5,$corcliente,'TR',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL NO SUJETO IVA',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'',1,1,'R'); //Titulo del reporte
	
		
		$this->Cell(28,5,'TELEFONO: ','LB',0,'L');
		$this->Cell(30,5,$telcliente,'B',0,'L');
		$this->Cell(35,5,'Referencia','B',0,'L');
		$this->Cell(35,5,$txnid.'-'.$serie,'BR',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL SIN IMPUESTOS',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'',1,1,'R'); //Titulo del reporte
		
		/*$this->Cell(15,5,'TITULO:','L',0,'L');
		$this->Cell(113,5,$comentario,'R',0,'L');
		$this->Cell(2,5,'',0,0,'L');*/
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'DESCUENTO',1,0,'l'); //Titulo del reporte
		$fdescuento = $english_format_number = number_format($fdescuento, 2, '.', '');
		$this->Cell(21,5,$fdescuento,1,1,'R'); //Titulo del reporte
		
		/*$this->Cell(25,5,'OBSERVACION:','L',0,'L');
		$this->Cell(103,5,substr($observa,0,60),'R',0,'L');*/
		//$this->Cell(128,5,'','LR',0,'L');
		//$this->Cell(2,5,'',0,0,'L');
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'ICE',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,0,1,1,'R'); //Titulo del reporte
		
		/*$this->Cell(128,5,substr($observa,61,60),'RL',0,'L');
		$this->Cell(2,5,'',0,0,'L');*/
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'IVA',1,0,'l'); //Titulo del reporte
		$fiva = $english_format_number = number_format($fiva, 2, '.', '');
		$this->Cell(21,5,$fiva,1,1,'R'); //Titulo del reporte
		
		/*$this->Cell(25,5,'F.PUBLICACION:','L',0,'L');
		$this->Cell(103,5,substr($fechapub,0,70),'R',0,'L');
		$this->Cell(2,5,'',0,0,'L');*/
		//$this->Cell(130,5,'',0,0,'L');
		//// $this->Cell(130,5,'',0,0,'L'); anterior formaro
		// $this->SetFont('Arial','B',7);
	   // $this->Cell(20,2,'',0,1);
	    $this->Cell(75,5,'Forma Pago',1,0,'C'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(20,5,'Valor',1,0,'C'); //**
	    $this->Cell(10,5,'Tiempo',1,0,'C'); //**
	    $this->Cell(20,5,'Plazo',1,0,'C');
		$this->Cell(5,5,'',0,0,'C');
		
		$this->Cell(40,5,'PROPINA',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,0,1,1,'R'); //Titulo del reporte
		
		/*$this->Cell(128,5,substr($fechapub,71,80),'RL',0,'L');*/
		//$this->Cell(2,5,'',0,0,'L');
		
		$this->Cell(75,5,$descsri,1,0,'L'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(20,5,$ftotalimp,1,0,'C'); //**
	    $this->Cell(10,5,$utiempo,1,0,'C'); //**
	    $this->Cell(20,5,$dplazo,1,0,'C');
		$this->Cell(5,5,'',0,0,'C');
		
		//$this->Cell(40,5,'PROPINA',1,0,'l'); //Titulo del reporte
		//$this->Cell(21,5,0,1,1,'R');
		$this->SetFillColor(118,184,225);
		//$this->Cell(130,5,'',0,0,'L');
		
		$this->SetFont('Arial','B',8);
		$this->Cell(40,5,'VALOR TOTAL',1,0,'l','true'); //Titulo del reporte
		$ftotalimp = $english_format_number = number_format($ftotalimp, 2, '.', '');
		$this->Cell(21,5,$ftotalimp,1,1,'R','true'); //Titulo del reporte
		$this->SetFont('Arial','',6);
		/*$this->Cell(128,5,substr($fechapub,151,80),'RLB',0,'L');*/
		//$this->Ln();
		
	}
	
	
	
	
	
		
	//El metodo para crear el encabezado
	function Header()
	{
	//$orden = 3;
	    $this->SetFont('Arial','B',7); //Tipo de letra, estilo y tamaño
	    $this->Cell(0,10,'',0,1,'C'); //Titulo del reporte
	    //$this->Image('logo_empresa.jpg',10,10,65,25);//punto X,Y ancho, alto//5,10,95,55
	    //$this->Cell(50,10,'No Orden de Compra: '.$orden,1,1,'C'); //Titulo del reporte
	   // $this->Cell(0,10,$gorden,0,1,'C'); //Titulo del reporte
	    
 

 
	}
 
	// Pie de página
	function Footer()
	{
		$gorden = 3;
	    // Posición: a 1,5 cm del final
	    $this->SetY(-18);
	    // Arial italic 8
	    
	    // Número de página
		$this->SetFont('Arial','B',8);
		//$this->Cell(190,5,'TERAN MARTINEZ ALVARO MARCELO',0,1,'C');
		//$this->Cell(190,5,'FIRMA AUTORIZADA',0,1,'C');
		$this->SetFont('Arial','I',8);
	    $this->Cell(0,10,'Pag '.$this->PageNo().'/{nb}',0,0,'C');
		//$this->Cell(5,15,' Orden'.$gorden,1,0,'C'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    //$this->Cell(10,25,'Cantidad',1,0,'C'); //**
	    //$this->Cell(10,30,'Precio',1,0,'C'); //**
	}

	function cabecera(){
		//Encabezado de la tabla
		$ubicaf = 40;
		$this->SetFillColor(118,184,225);
		//$this->SetTextColor(240, 255, 240);//letras blancas
		$this->SetXY(10,$ubicaf);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(60,6,'Codigo ',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(100,6,'Descripcion de la Cuenta',1,0,'C','true'); //**
	    $this->Cell(30,6,'Saldo',1,1,'C','true'); //**
	    
		//$this->SetFillColor(255,255,255);
	}
	
	
	function cabecerabc(){
		//Encabezado de la tabla
		$ubicaf = 40;
		$this->SetFillColor(118,184,225);
		//$this->SetTextColor(240, 255, 240);//letras blancas
		$this->SetXY(10,$ubicaf);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(40,6,'CODIGO ',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(60,6,'DESCRIPCION DE LA CUENTA',1,0,'C','true'); //**
	    $this->Cell(20,6,'SALDO ANTERIOR',1,0,'C','true'); //**
		$this->Cell(20,6,'DEBITOS',1,0,'C','true'); //**
		$this->Cell(20,6,'CREDITOS',1,0,'C','true'); //**
		$this->Cell(30,6,'SALDO',1,1,'C','true'); //**
	    
		//$this->SetFillColor(255,255,255);
	}



    function cabeceracc(){
		//Encabezado de la tabla
		$ubicaf = 50;
		$this->SetFillColor(118,184,225);
		//$this->SetTextColor(240, 255, 240);//letras blancas
		$this->SetXY(10,$ubicaf);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(100,6,'Descripcion ',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(10,6,'Mes',1,0,'C','true'); //**
	    $this->Cell(10,6,'Anio',1,0,'C','true'); //**
	    $this->Cell(10,6,'Valor',1,0,'C','true'); //**
		$this->Cell(60,6,'Tipo',1,1,'C','true'); //**
		//$this->SetFillColor(255,255,255);
	}


    function detallecc($cn,$loteid,$tipocc){
        $datos = date('Y-m');
		$aniop = $datos.'-31';
		$sqlord = "SELECT l.descripcion as descrip,l.mes,l.anio,l.valor,t.descripcion 
		FROM lotesalicuotas l, tipocuota t WHERE l.tipo = t.tipocuotaid and l.loteid = $loteid and l.estado = $tipocc 
	    and ultimopago <= '$aniop'  order by tipo,anio,CAST(mes AS SIGNED)";
			
	
	
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de factura Pdf detalle NC interno";
				//exit;

		} else {
			$ubicaf = 56;
			while($fila2 = $resulm->fetch_assoc()){
			
				 $page_line = 266; // mm (portrait letter)

				if ($ubicaf >= $page_line){
					$this->AddPage(); // page break.
					$ubicaf = 10;
					//$this->cabecera();
				} else {
					 $this->SetFont('Arial','',8);
					 $this->SetXY(10,$ubicaf);
					 $y1 = $this->GetY();
					 $x1 = $this->GetX();			 
					 $this->Cell(100,4,utf8_decode($fila2['descrip']),1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
					 $y2 = $this->GetY();
					 $alto = $y2 - $y1 ;
					 $alto = 4;
					 $this->SetXY(110,$ubicaf);
					 $this->Cell(10,$alto,$fila2['mes'],1,0); //id  
					 $this->SetXY(120,$ubicaf);
					 $this->Cell(10,$alto,$fila2['anio'],1,0,'C'); //**
					 $this->SetXY(130,$ubicaf);
					 $valor = $fila2['valor'];
					 $precu = $english_format_number = number_format($valor, 2, '.', '');
					 $this->Cell(10,$alto,$precu,1,0,'R'); //** 
					 $this->SetXY(140,$ubicaf);
					 $tipo = $fila2['descripcion'];
					 //$tipodesc = buscatipodesc($cn,$tipo);
					 //$desctipo = tipocc($tipo);
					 $this->Cell(60,$alto,$tipo,1,0,'R'); //**
					 
					 $ubicaf = $ubicaf + 4;
				} 
		 
			}

		}
	
	}
	
	
	function totalescc($cn,$loteid,$tipocc){
	   $datos = date('Y-m');
		$aniop = $datos.'-31';
		$sqlord = "SELECT sum(l.valor) as valor,t.descripcion FROM lotesalicuotas l, tipocuota t 
		           WHERE l.tipo = t.tipocuotaid and l.loteid = $loteid and l.estado = $tipocc and  ultimopago <= '$aniop' group by l.tipo";
	
	
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de factura Pdf detalle NC interno";
				//exit;

		} else {
			$total = 0;
			$this->ln();
			while($fila2 = $resulm->fetch_assoc()){
			
				 $this->SetFont('Arial','B',9); 
				 $this->Cell(100,6,'TOTAL '.utf8_decode($fila2['descripcion']),1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
				 $alto = 6;
				 $valor = $fila2['valor'];
				 $precu = $english_format_number = number_format($valor, 2, '.', '');
				 $this->Cell(30,$alto,$precu,1,1,'R'); //** 
				 $total = $total + $valor;
				 $ubicaf = $ubicaf + 6;
				 
		 
			}
			$this->Cell(100,6,'TOTAL GENERAL ',1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
			 $alto = 6;
			 $total1 = $english_format_number = number_format($total, 2, '.', '');
			 $this->Cell(30,$alto,$total1,1,1,'R');

		}
	}
	
	
	
	function buscatipodesc($cn,$tipo){
		$sqle = "SELECT descripcion FROM tipocuota WHERE tipocuotaid = $tipo";
		if (!$resulme = $cn->query($sqle)) {
				echo "Error en Query de tipo cuota";
				exit;

		} else {
			while ($registroe = $resulme->fetch_assoc()){  
				echo 'ingresa while';
				$desc =  $registroe['descripcion'];
			}
		}	
		return $desc;
	}
	
	
	function pagoscajeroold($cn,$usuario,$fdesde,$fhasta){
		$tot = 0;
		if (strlen($usuario) > 0){
			$sqle = "SELECT sum(d.detalleformapagomonto) as valor,d.codigosri, p.FormaPagoNombre FROM facturas f, detalleformaspago d, formasdepago p WHERE f.FacturaId = d.FacturaId and d.formapagoid = p.formapagoid and f.usuarioid = '$usuario' and d.detalleformapagocreacion >= '$fdesde' and d.detalleformapagocreacion <= '$fhasta' group by p.formapagoid";
		} else {
			$sqle = "SELECT sum(d.detalleformapagomonto) as valor,d.codigosri, p.FormaPagoNombre FROM detalleformaspago d, formasdepago p WHERE d.formapagoid = p.formapagoid and detalleformapagocreacion >= '$fdesde' and d.detalleformapagocreacion <= '$fhasta' group by p.formapagoid";
			$usuario = 'TODOS';
		}
		
		if (!$resulme = $cn->query($sqle)) {
				echo "Error en Query de empresa Pdf balance analitico";
				exit;

		} else {
			$this->Ln();
			$this->Ln();
			$this->Ln();
			$ubicaf = 50;
			$this->Cell(30,6,'Recaudador: ',0,0,'L');
			$this->Cell(40,6,$usuario,0,0,'L');
			$this->Ln();
			$this->SetFont('Arial','',9);
			while ($registroe = $resulme->fetch_assoc()){  
				echo 'ingresa while';
				$valor =  $registroe['valor'];
				$codigosri =  $registroe['codigosri'];
				$this->SetXY(10,$ubicaf);
				$nombre =  utf8_decode($registroe['FormaPagoNombre']);
				$this->Cell(80,6,$nombre,1,0,'L');
				$valor1 = $english_format_number = number_format($valor, 2, '.', '');
				$this->Cell(20,6,$valor1,1,1,'R');
				$tot = $tot + $valor;
				$ubicaf = $ubicaf + 6;			
			}
			$this->SetFont('Arial','B',9);
			$this->Cell(80,6,'TOTAL GENERAL ',1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
			 $alto = 6;
			 $total1 = $english_format_number = number_format($tot, 2, '.', '');
			 $this->Cell(20,$alto,$total1,1,1,'R');
		}
	}
	
	
	function pagoscajero($cn,$usuario,$fdesde,$fhasta){
		$tot = 0;
	    if (strlen($usuario) > 0){
			//$sqle = "SELECT sum(d.detalleformapagomonto) as valor,d.codigosri, p.FormaPagoNombre, f.usuarioid FROM facturas f, detalleformaspago d, formasdepago p WHERE f.FacturaId = d.FacturaId and d.formapagoid = p.formapagoid and f.usuarioid = '$usuario' and substr(d.detalleformapagocreacion,1,10) = '$fdesde' and d.formapagoid = 1 group by f.usuarioid";
			$sqle = "SELECT login FROM sec_users WHERE recaudador = 'S' and login = '$usuario'";
		} else {
			//$sqle = "SELECT sum(d.detalleformapagomonto) as valor,d.codigosri, p.FormaPagoNombre, f.usuarioid FROM facturas f, detalleformaspago d, formasdepago p WHERE f.FacturaId = d.FacturaId and d.formapagoid = p.formapagoid and d.detalleformapagocreacion >= '$fdesde' and d.detalleformapagocreacion <= '$fhasta' and d.formapagoid = 1 group by f.usuarioid";
			$sqle = "SELECT login FROM sec_users WHERE recaudador = 'S'";
			$usuario = 'TODOS';
		}
		
		if (!$resulme = $cn->query($sqle)) {
				echo "Error en Query de empresa Pdf balance analitico";
				exit;

		} else {
			/*$this->Ln();
			$this->Ln();
			
			$this->Ln();*/
			
			$ubicaf = 56;
			/*$this->Cell(30,6,'Recaudador: ',0,0,'L');
			$this->Cell(40,6,$usuario,0,0,'L');*/
			$this->Ln();
			$this->SetFont('Arial','',9);
			while ($registroe = $resulme->fetch_assoc()){  
				//echo 'ingresa while';
				$totlin = 0;
				//$valor =  $registroe['valor'];
				//$codigosri =  $registroe['codigosri'];
				$nombre =  $registroe['login'];
				// se modifica poceso para que se filtre cajeros que no están en base a fecha de salida de tabla sec_users
				//27/ene/2021
				$vallogin = validafechasalida($cn,$nombre);
				echo 'fdesde '.$fdesde.' fecha salida '.$vallogin;
				
				if ($vallogin == 'S'){
				    $despliega = 'S';
				}   else {
				    //cambiar strototime funciona de lujo
				    //27/ene/2021
				    $fec1 = strtotime($fdesde);
				    $fec3 = strtotime($vallogin);
				    if ($fec3 >= $fec1){
				        $despliega = 'S';    
				    } else {
				        $despliega = 'N';
				    }
				}
				
				if ($despliega == 'S'){
				    
    				$this->SetXY(10,$ubicaf);
    				
    				$nombre2 =  utf8_decode($registroe['login']);
    				$this->Cell(80,6,$nombre2,1,0,'L');
    				$tipofpago = 1;
    				$valor = valorfpago($cn,$nombre,$fdesde,$fhasta,$tipofpago);
    				$valor1 = $english_format_number = number_format($valor, 2, '.', '');
    				$this->Cell(30,6,$valor1,1,0,'R');
    				$tipofpago = 2;
    				$valorch = valorfpago($cn,$nombre,$fdesde,$fhasta,$tipofpago);
    				$valorch1 = $english_format_number = number_format($valorch, 2, '.', '');
    				$this->Cell(30,6,$valorch1,1,0,'R');
    				$tipofpago = 3;
    				$valortj = valorfpago($cn,$nombre,$fdesde,$fhasta,$tipofpago);
    				$valortj1 = $english_format_number = number_format($valortj, 2, '.', '');
    				$this->Cell(30,6,$valortj1,1,0,'R');
    				
    				$tipofpago = 5;
    				$valortr = valorfpago($cn,$nombre,$fdesde,$fhasta,$tipofpago);
    				$valortr1 = $english_format_number = number_format($valortr, 2, '.', '');
    				$this->Cell(30,6,$valortr1,1,0,'R');
    				$tipofpago = 4;
    				$valortd = valorfpago($cn,$nombre,$fdesde,$fhasta,$tipofpago);
    				$valortd1 = $english_format_number = number_format($valortd, 2, '.', '');
    				$this->Cell(30,6,$valortd1,1,0,'R');
    				$tot = $tot + $valor;
    				$totch = $totch + $valorch;
    				$tottj = $tottj + $valortj;
    				$tottr = $tottr + $valortr;
    				$tottd = $tottd + $valortd;
    				$totlin = $valor + $valorch + $valortj + $valortr + $valortd;
    				$totlin1 = $english_format_number = number_format($totlin, 2, '.', '');
    				$this->Cell(30,6,$totlin1,1,1,'R');
    				$ubicaf = $ubicaf + 6;	
				}
			}
			$this->SetFont('Arial','B',9);
			$this->Cell(80,6,'TOTAL GENERAL ',1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
			 $alto = 6;
			 $totalgen = $tot + $totch + $tottj + $tottr + $tottd;
			 $total1 = $english_format_number = number_format($tot, 2, '.', '');
			 $totalch = $english_format_number = number_format($totch, 2, '.', '');
			 $totaltj = $english_format_number = number_format($tottj, 2, '.', '');
			 $totaltr = $english_format_number = number_format($tottr, 2, '.', '');
			 $totaltd = $english_format_number = number_format($tottd, 2, '.', '');
			 $totalgen = $english_format_number = number_format($totalgen, 2, '.', '');
			 $this->Cell(30,$alto,$total1,1,0,'R');
			 $this->Cell(30,$alto,$totalch,1,0,'R');
			 $this->Cell(30,$alto,$totaltj,1,0,'R');
			 $this->Cell(30,$alto,$totaltr,1,0,'R');
			 $this->Cell(30,$alto,$totaltd,1,0,'R');
			 $this->Cell(30,$alto,$totalgen,1,1,'R');
		}
		
		
		
	}
	
	
	function cabecerafpago(){
		//Encabezado de la tabla
		$ubicaf = 50;
		$this->SetFillColor(118,184,225);
		//$this->SetTextColor(240, 255, 240);//letras blancas
		$this->SetXY(10,$ubicaf);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(80,6,'Recaudador ',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(30,6,'Efectivo',1,0,'C','true'); //**
	    $this->Cell(30,6,'Cheque',1,0,'C','true'); //**
	    $this->Cell(30,6,'Tarjeta C.',1,0,'C','true'); //**
		$this->Cell(30,6,'Transferencia',1,0,'C','true'); //**
		$this->Cell(30,6,'Tarjeta D.',1,0,'C','true'); //**
		$this->Cell(30,6,'Total',1,1,'C','true'); //**
		//$this->SetFillColor(255,255,255);
	}
	
	
	function inicionc($rsocial,$ncomercial,$ruc,$secuenciale,$dirmatriz,$cespecial,$oconta,$rscliente,$icliente,$ffechac,$descta,$desctipoe,$clavep,$estab,$ptoemi,$dircliente,
	                $coddoc,$numdoc,$fechae,$dirsuc,$telefono,$rinven,$ptoemi2){
		//substr($nprove1,80)
	//$this->Ln();
	$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',10);
	$this->Cell(90,5,'','TLR',1,'L');
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',12);
	$this->Cell(90,5,$rsocial,'LR',1,'L');
    //Titulo del reporte	
	$this->SetFont('Arial','',10);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,5,'RUC: ','L',0,'L');
	$this->Cell(80,5,$ruc,'R',1,'L');
	
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');	
	$this->SetFont('Arial','B',11);
	$this->Cell(90,10,'NOTA DE CREDITO ','RL',1,'L');
	$this->Cell(100,10,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(10,10,'No','L',0,'C'); 
	$this->SetFont('Arial','',9);
	$this->Cell(80,10,''.$estab.'-'.$ptoemi.'-'.$secuenciale,'R',1,'L');
	$this->Cell(100,10,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(90,10,'NUMERO AUTORIZACION','LR',1,'L'); 
	$this->Cell(100,10,' ',0,0,'C');
	$this->SetFont('Arial','',8);
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','',9);
	$this->Cell(90,10,$clavep,'LR',1,'C');
	$this->Cell(100,10,' ',0,0,'C'); 
	
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(20,7,'AMBIENTE','L',0,'L'); 
	$this->SetFont('Arial','',9);
	$this->Cell(70,7,''.$descta,'R',1,'L');
	$this->Cell(100,8,' ',0,0,'C');
	//$this->Cell(90,10,'',0,1,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(20,8,'EMISION','L',0,'L'); 
	$this->SetFont('Arial','',9);
	$this->Cell(70,8,''.$desctipoe,'R',1,'L');
	
	//$this->Cell(80,40,'',1,0,'L'); //Titulo del reporte
	$this->Cell(100,5,$ncomercial,'TRL',0,'L'); //Titulo del reporte
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,5,'   ','RL',1,'L');
	$this->SetFont('Arial','B',7);
	$this->Cell(30,5,utf8_decode('Direccion Matriz: '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(70,5,utf8_decode(substr($dirmatriz,0,79)),'R',0,'L');
	$this->Cell(1,5,'',0,0,'L'); //Titulo del reporte
	//$html =  "<img src='https://barcode.tec-it.com/barcode.ashx?data=17111111111111111111111111&code=EANUCC128&translate-esc=on&dpi=72&dataseparator=' alt='Barcode Generator TEC-IT' width='250' height='35'/>";
	//$this->WriteHTML($html);
	$this->Cell(90,5,'','RL',1,'L'); //Ruc en la tabla Empresac
	
	$this->SetFont('Arial','B',7);
	$this->Cell(30,5,utf8_decode('Direccion Sucursal: '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(70,5,utf8_decode($dirsuc),'R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); //Titulo del reporte
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,5,'','LR',1,'L'); //Titulo del reporte
	$this->SetFont('Arial','B',7);
	$this->Cell(40,5,'Telefono: ','L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(60,5,$telefono,'R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); //Titulo del reporte
	$this->code128(115,80,$clavep,80,10);
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',7);
	$this->Cell(90,5,'CLAVE DE ACCESO','RL',1,'L');
	$this->SetFont('Arial','',7);
	
	if ($oconta == 'S'){
		$oconta2 = 'SI';
	} else {
		$oconta2 = 'NO';
	}
	$this->SetFont('Arial','B',7);
	$this->Cell(40,5,'Contribuyente Especial Nro:  ','L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(60,5,$cespecial,'R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); 
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,5,$clavep,'RL',1,'C'); //Titulo del reporte
	//$this->Cell(100,5,'','LRB',0,'C'); //Linea en blanco
	$this->SetFont('Arial','B',7);
	
	$this->Cell(40,5,'Obligado a llevar Contabilidad:  ','LB',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(10,5,$oconta2,'B',0,'L');
	$this->Cell(50,5,$rinven,'BR',0,'L');
	$this->Cell(1,5,'',0,0,'L');
	
	$this->Cell(90,5,'','RLB',1,'L');
	$this->Cell(90,2,'',0,1,'L');
	// Datos Cliente
	//$this->SetFont('Arial','B',9);
	//$this->SetY(10);
	//$this->Cell(40,10,utf8_decode('Razón Social / Nombres: '),'TL',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->SetXY(50,107);
	$y1 = $this->GetY();
	$x1 = $this->GetX();	
	$this->SetFillColor(255,255,255);
	if (strlen(trim($rscliente)) >= 56){
		$this->Cell(100,5,''.substr($rscliente,0,55),'T',0,'L');
		$slinea = 'T';
	}	else {
		$this->Cell(100,5,''.$rscliente,'T',0,'L');
		$slinea = 'F';
	}	
	
	$y2 = $this->GetY();
	$alto = 5 ;
	$this->SetFont('Arial','B',9);
	$this->SetXY(150,107);
	$this->Cell(25,$alto,utf8_decode('Identificacion'),'T',0,'L');
	//$this->SetFont('Arial','B',9);
	$this->SetXY(10,107);
	$this->Cell(40,$alto,utf8_decode('Razon Social / Nombres: '),'TL',0,'L'); //Titulo del reporte
	$this->SetXY(175,107);
	$this->SetFont('Arial','',8);
	$this->Cell(26,$alto,''.$icliente,'TR',1,'L');
	if ($slinea == 'T'){
		$this->SetXY(10,112);
		$this->Cell(191,5,''.substr($rscliente,55,119),'LR',1,'L');
	}	
	
	
	$this->SetFont('Arial','B',9);
	$this->Cell(40,5,utf8_decode('Fecha emision '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(100,5,''.$ffechac,'',0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(20,5,'','',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(31,5,'','R',1,'L');
	
	$this->Cell(10,5,'','L',0,'L');
	$this->Cell(170,5,'','B',0,'L');
	$this->Cell(11,5,'','R',1,'L');
	
	if ($coddoc == '01'){
		$fact = 'FACTURA';
	}
	$numdoc2 = substr($numdoc,0,3).'-'.substr($numdoc,3,3).'-'.substr($numdoc,6,14);
	$this->SetFont('Arial','B',9);
	$this->Cell(60,5,utf8_decode('Comprobante que se modifica '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(50,5,''.$fact,'',0,'L');
	$this->SetFont('Arial','',9);
	$this->Cell(40,5,$numdoc2,'',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(41,5,'','R',1,'L');
	
	$this->SetFont('Arial','B',9);
	$this->Cell(60,5,utf8_decode('Razon de modificacion '),'LB',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(50,5,'SE ANULA: '.$numdoc2,'B',0,'L');
	$this->SetFont('Arial','',9);
	$this->Cell(40,5,'','B',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(41,5,'','RB',1,'L');
	
	$this->Cell(90,2,'',0,1,'L');
	}
	
	function detallenc($factid,$cn,$rscliente){
		$sqlord = "SELECT f.codigoprincipal,f.descripcion,f.cantidad,f.preciounitario,f.descuento,
	f.baseimponible,f.codigo,f.codigoporcentaje,f.tarifa,f.valor
	FROM detalle_factura f WHERE f.facturaid = $factid";
	
	
		if (!$resulm = $cn->query($sqlord)) {
				echo "Error en Query de factura Pdf detalle NC interno";
				//exit;

		} else {
		if (strlen(trim($rscliente)) >= 50){
			$ubicaf = 150;
		} else {
			$ubicaf = 140;
		}
		while($fila2 = $resulm->fetch_assoc()){
			
				
			$this->SetFont('Arial','',8);
			 $this->SetXY(45,$ubicaf);
			 $y1 = $this->GetY();
			 $x1 = $this->GetX();			 
			 $this->Cell(80,4,substr($fila2['descripcion'],0,46),1,0,'L'); //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
			 $y2 = $this->GetY();
			 $alto = $y2 - $y1 ;
			 $alto = 4;
			 $this->SetXY(10,$ubicaf);
			 $this->Cell(35,$alto,$fila2['codigoprincipal'],1,0); //id  
			 $this->SetXY(125,$ubicaf);
			 $this->Cell(15,$alto,$fila2['cantidad'],1,0,'C'); //**
			 $this->SetXY(140,$ubicaf);
			 $precu = $fila2['preciounitario'];
			 $precu = $english_format_number = number_format($precu, 2, '.', '');
			 $this->Cell(20,$alto,$precu,1,0,'R'); //** 
			 $this->SetXY(160,$ubicaf);
			 $descu = $fila2['descuento'];
			 $descu = $english_format_number = number_format($descu, 2, '.', '');
			 $this->Cell(20,$alto,$descu,1,0,'R'); //**
			 $this->SetXY(180,$ubicaf);
			 $baseimp = $fila2['baseimponible'];
			 $baseimp = $english_format_number = number_format($baseimp, 2, '.', '');
			 $this->Cell(21,$alto,$baseimp,1,1,'R');
			 $ubicaf = $ubicaf + 4;
		 
		}

	}
	//$varo = round($varo,2);

	}
	
	
	
	
	function WriteHTML($html)
	{
		// Intérprete de HTML
		$html = str_replace("\n",' ',$html);
		$a = preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
		foreach($a as $i=>$e)
		{
			if($i%2==0)
			{
				// Text
				if($this->HREF)
					$this->PutLink($this->HREF,$e);
				else
					$this->Write(5,$e);
			}
			else
			{
				// Etiqueta
				if($e[0]=='/')
					$this->CloseTag(strtoupper(substr($e,1)));
				else
				{
					// Extraer atributos
					$a2 = explode(' ',$e);
					$tag = strtoupper(array_shift($a2));
					$attr = array();
					foreach($a2 as $v)
					{
						if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
							$attr[strtoupper($a3[1])] = $a3[2];
					}
					$this->OpenTag($tag,$attr);
				}
			}
		}
	}	
	function OpenTag($tag, $attr)
{
    // Etiqueta de apertura
    if($tag=='B' || $tag=='I' || $tag=='U')
        $this->SetStyle($tag,true);
    if($tag=='A')
        $this->HREF = $attr['HREF'];
    if($tag=='BR')
        $this->Ln(5);
}

function CloseTag($tag)
{
    // Etiqueta de cierre
    if($tag=='B' || $tag=='I' || $tag=='U')
        $this->SetStyle($tag,false);
    if($tag=='A')
        $this->HREF = '';
}

function SetStyle($tag, $enable)
{
    // Modificar estilo y escoger la fuente correspondiente
    $this->$tag += ($enable ? 1 : -1);
    $style = '';
    foreach(array('B', 'I', 'U') as $s)
    {
        if($this->$s>0)
            $style .= $s;
    }
    $this->SetFont('',$style);
}

function PutLink($URL, $txt)
{
    // Escribir un hiper-enlace
    $this->SetTextColor(0,0,255);
    $this->SetStyle('U',true);
    $this->Write(5,$txt,$URL);
    $this->SetStyle('U',false);
    $this->SetTextColor(0);
}
	
}

/*function Footer2()
{
	$gorden = 3;
    // Posición: a 1,5 cm del final
 	
}*/

function Footer2()
{
	$gorden = 3;
    // Posición: a 1,5 cm del final
    $this->SetY(-45);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Número de página
 
    $this->Cell(0,10,'Pag '.$this->PageNo().'/{nb}',0,0,'C');
	$this->Cell(5,15,' Orden'.$gorden,1,0,'C'); //ancho,alto,dato,borde,salto,alineacion centrado**
   

}

function calculasaldob($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores){
		if ($ultimonivel == 1){
			$sql = "SELECT sum(debeacumulado) - sum(haberacumulado) as total FROM mayorizacionc WHERE cuentacontableid = $cuentaid";

		}	elseif ($padreid == 0) {
			$sql = "SELECT sum(m.debeacumulado) - sum(m.haberacumulado) as total FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1 and c.tiposid = $tipos";
			
		}	elseif ($padreid > 0 and $ultimonivel == 0){
			$sql = "SELECT sum(debeacumulado) - sum(haberacumulado) as total FROM mayorizacionc WHERE cuentacontableid  in ($valores)";
			
		}
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion saldo reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$saldo = $fila['total'];
				return $saldo;
			}	
		}
	}
	
	function calculasaldotipos($cn,$tipos){
		$sql = "SELECT sum(m.debeacumulado) - sum(m.haberacumulado) as total FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1 and c.tiposid = $tipos";
			
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion saldo reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$saldo = $fila['total'];
				return $saldo;
			}	
		}
	}
	
	
	function calculasaldototal($cn){
		$sql = "SELECT sum(m.debeacumulado) - sum(m.haberacumulado) as total FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1 ";
			
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion saldo reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$saldo = $fila['total'];
				return $saldo;
			}	
		}
	}
	
	function calculadebhabtipos($cn,$cuentaid,$tipos,$tipoc){
		$sql = "SELECT sum(m.debeacumulado) as debe, sum(m.haberacumulado) as haber FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1 and c.tiposid = $tipos";
			
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion debe haber total reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$debe = $fila['debe'];
				$haber = $fila['haber'];
				if ($tipoc == 'D'){
					return $debe;
				}	elseif ($tipoc == 'C'){
					return $haber;
				}	
			}	
		}
	}
	
	function calculadebhabtotal($cn,$tipoc){
		$sql = "SELECT sum(m.debeacumulado) as debe, sum(m.haberacumulado) as haber FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1";
			
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion debe haber total reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$debe = $fila['debe'];
				$haber = $fila['haber'];
				if ($tipoc == 'D'){
					return $debe;
				}	elseif ($tipoc == 'C'){
					return $haber;
				}	
			}	
		}
	}
	
	function traedebehaber($cn,$cuentaid,$tipos,$padreid,$ultimonivel,$valores,$tipoc){
		if ($ultimonivel == 1){
			$sql = "SELECT sum(debeacumulado) as debe, sum(haberacumulado) as haber FROM mayorizacionc WHERE cuentacontableid = $cuentaid";

		}	elseif ($padreid == 0) {
			$sql = "SELECT sum(m.debeacumulado) as debe,sum(m.haberacumulado) as haber FROM mayorizacionc m, cuentacontable c WHERE m.cuentacontableid = c.cuentacontableid and c.ultimonivel = 1 and c.tiposid = $tipos";
			
		}	elseif ($padreid > 0 and $ultimonivel == 0){
			$sql = "SELECT sum(debeacumulado) as debe, sum(haberacumulado) as haber FROM mayorizacionc WHERE cuentacontableid  in ($valores)";
			
		}
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion debe haber reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$debe = $fila['debe'];
				$haber = $fila['haber'];
				if ($tipoc == 'D'){
					return $debe;
				} elseif ($tipoc == 'C'){
					return $haber;
				}
			}	
		}
	}
	
	
	function valorfpago($cn,$usuario,$fdesde,$fhasta,$tipofpago){
	    $usuario1 = trim($usuario);
	    $fdesde1 = substr($fdesde,0,4).'-'.substr($fdesde,4,2).'-'.substr($fdesde,6,2);
	    $fhasta1 = trim($fhasta);
	    $tipofpago1 = trim($tipofpago);
	    echo $usuario1;
	    echo $fhasta1;
	    echo $tipofpago1.'<br>';
	    if ($fdesde == $fhasta){
	        	$sqle = "SELECT sum(d.detalleformapagomonto) as valor FROM facturas f, detalleformaspago d, formasdepago p WHERE f.FacturaId = d.FacturaId and d.formapagoid = p.formapagoid and f.usuarioid = '$usuario1' and substr(f.facturafechacreacion,1,10) = '$fdesde1' and d.formapagoid = $tipofpago1";
	    } else {
    		$sqle = "SELECT sum(d.detalleformapagomonto) as valor FROM facturas f, detalleformaspago d, formasdepago p WHERE f.FacturaId = d.FacturaId and d.formapagoid = p.formapagoid and f.usuarioid = '$usuario' and f.facturafechacreacion >= '$fdesde' and f.facturafechacreacion <= '$fhasta' and d.formapagoid = $tipofpago ";
	    }
		if (!$resulme = $cn->query($sqle)) {
				echo "Error en Query de empresa Pdf fpago".$fdesde1;
				exit;

		} else {
			while ($registroe = $resulme->fetch_assoc()){  
				echo 'ingresa while';
				$valor =  $registroe['valor'];
				return $valor;
			}	
		}	
	}
	
	function validafechasalida($cn,$login){
		$sql = "select fecha_salida from sec_users where login = '$login'";
			
		if (!$resulm = $cn->query($sql)) {
				echo "Error en Query de funcion debe haber total reportes contables";
				//exit;

		} else {
			while($fila = $resulm->fetch_assoc()){ 
				$fechas = $fila['fecha_salida'];
				if (is_null($fechas)){
					return $fechas = 'S';
				}	else {
					return $fechas;
				}	
			}	
		}
	}
?>
